var users_mark = "x";
var comps_mark = "o";
var flavour = "blueberry";

var finished = false;

function selectMark(which) {
    users_mark = which;
            
    (which == "x") ? comps_mark = "o" : comps_mark = "x";
            
     /* 
        OK, there's some weird bug that I can't fathom here...
        Apparently, using the following:
                
        document.getElementById(users_mark + "_mark").style.opacity = 1.0;
        document.getElementById(comps_mark + "_mark").style.opacity = 0.5;
                
        will not work in this new build. WTF? Seems that it's only using the first digit - hence the
        opacity of the compters mark is always set to zero (or 1 if using 1.0).
        Now this is weird, because calling it from elsewhere (say in init())
        works just fine. Also, explicity setting:
        document.getElementById("o_mark").style.opacity = 0.5;
        also works. So it would appear to be something in the way it's evaluating the
        id between the parenthesis?
        However, getting the opacity value returns just the
        first digit, again....
                
        This only seems to apply to images, and only seems to apply when
        it's an event which involves mouse interaction...
        For example, the code can be modified to make the body tag have an opacity
        of 0.5, but won't work on any images :/
        Is this maybe something to do with having to set the composite attribute?
        Although - that would only affect the code when launched in the dashboard
        and not affect safari, i would imagine (since composite isn't understood in safari...)
        Ah well - in order to work round this problem, we'll put in spans
        that have the corresponding image as their background...
                
        OK - even that didn't work. So it doesn't just apply to images...
        How come the opacity can be changed of some things and not others? 
        I don't have the time or energy to track this down... grr.
                
        Actually (gosh this is a rambling comment...) I've found a workaround.
        The following two lines solve it - it seems they need to be used first,
        and two different styles applied. No idea why the need to be different...
        This is quite strange, but seems like there'll be some obvious reasoning
        behind it - it feels like that kind of bug, if you know what I mean :)
    */

    document.getElementById(users_mark + "_mark").style.display = "inline";
    document.getElementById(comps_mark + "_mark").style.display = "inline-block";
            
    document.getElementById(comps_mark + "_mark").style.opacity = 0.5;
    document.getElementById(users_mark + "_mark").style.opacity = 1.0;
            
    //obviously need to restart it if they've chosen a new mark. otherwise it's 'Cheeeaaaating' according to Rick ;)
    if (window.widget) {
        widget.setPreferenceForKey(users_mark, "users_mark");
        replay();
    }
}

function userClick(e) {
    (document.addEventListener) ? e = e.target : e = event.srcElement;
        
    // check if the square has been clicked on, if not add the users input to the box they just clicked on
    //can't disable DIV elements in Moz, so have to check if it's been clicked on already
        
    if (e.className == "square" && e.getAttribute("state") == null) {
        e.setAttribute("state", users_mark);
            
        //now do the animation Rick's so fond of:
        e.style.backgroundImage = "url(ui/" + flavour + "/piece_" + users_mark + "_drop_0.png)";
        setTimeout(function() {	
                e.style.backgroundImage = "url(ui/" + flavour + "/piece_" + users_mark + "_drop_1.png)";
                    setTimeout(function() {	
                                e.style.backgroundImage = "url(ui/" + flavour + "/piece_" + users_mark + "_drop_2.png)";
                                setTimeout(function() {	
                                        e.style.backgroundImage = "url(ui/" + flavour + "/piece_" + users_mark + "_normal.png)";
                                        //obviously do the checking in here now, so that things flow properly :)
                                        checkIfWon(); //make sure the user hasn't already won the game before doing the comps go
    
                                        if (!finished) {
                                            computersGo();
                                            checkIfWon();	
                                        }
                                    }, 70);
                            }, 50);
                        }, 30);				
    }
}
    
function computersGo() {
    /*
        sets canuse to null each time, so that for the last shot it is still null and so nothing 
        is added to the previous canuse that was specified (canuse would have retained this value, 
        so multiple O's or X's would've been placed in) - make sense?
    
        check for two next to each other about to make a line on the users next go, if this is correct,
        block it - otherwise put one down in the row or column with the most free spaces, preferably a corner
        NOTE: only check for two marks about to cause a line, cos thats all that's necessary
    */
    
    var canuse = null; 
    var needtoblock = false;
    
    // have to check all the values in everything
    
    //now, rather than breaking out when we see the first block, we'll carry on going to see if we can win...
    
    var tocheck = document.getElementById("game_board").childNodes;
    
    for (var i=0; i < 9; i++) {
        //check every square and find if there's two there
        if (tocheck[i].getAttribute("state") != null) { 
            //check down first column only - if there's a match then the computers mark goes in the last column
            if (i == 0 || i == 3 || i == 6) {
                if (tocheck[i].getAttribute("state") == tocheck[i+1].getAttribute("state")) { //check for two in a row (so first two columns)
                    if (tocheck[i+2].getAttribute("state") == null) {
                        canuse = "square_" + ((i*1)+3); //times it by one so that Moz realises its a number not a string so that numerical addition can be done with it, not string appending
                        if (!needtoblock) needtoblock = true;
                        if (tocheck[i].getAttribute("state") == comps_mark) break; //so we can win! (overriding the default behaviour of just dumbly blocking every move instead of being more 'aggressive' :)
                    }
                }
                    
                if (tocheck[i].getAttribute("state") == tocheck[i+2].getAttribute("state")) { //check for two on opposing sides (columns)
                    if (tocheck[i+1].getAttribute("state") == null) {
                        canuse = "square_" + ((i*1)+2); //times it by one so that Moz realises its a number not a string so that numerical addition can be done with it, not string appending
                        if (!needtoblock) needtoblock = true;
                        if (tocheck[i].getAttribute("state") == comps_mark) break;
                    }
                }
            }
            
            // now check down second column - put a mark in first column if theres two in a row
            if (i == 1 || i == 4 || i == 7) {
                if (tocheck[i].getAttribute("state") == tocheck[i+1].getAttribute("state")) { //check for two in a row (so first two columns)
                    if (tocheck[i-1].getAttribute("state") == null) {
                        canuse = "square_" + i; // the number before the one we're at - i've given the squares id's starting from 1, but the childnodes start at 0
                        if (!needtoblock) needtoblock = true;
                        if (tocheck[i].getAttribute("state") == comps_mark) break;
                    }
                }
            }	
            
            // now check for two matches in the columns - first two rows we need to look along
            if (i < 3) { //first row			
                if (tocheck[i].getAttribute("state") == tocheck[i+3].getAttribute("state")) { //check for two in a row (so first two columns)
                    if (tocheck[i+6].getAttribute("state") == null) {
                        canuse = "square_" + ((i*1)+7); // put the mark in the middle row
                        if (!needtoblock) needtoblock = true;
                        if (tocheck[i].getAttribute("state") == comps_mark) break;
                    }
                }
                    
                if (tocheck[i].getAttribute("state") == tocheck[i+6].getAttribute("state")) { //check for two on opposing sides of the board
                    if (tocheck[i+3].getAttribute("state") == null) {
                        canuse = "square_" + ((i*1)+4); // put the mark in the last row
                        if (!needtoblock) needtoblock = true;
                        if (tocheck[i].getAttribute("state") == comps_mark) break;
                    }
                }
            }
                
            // second row
            if (i > 2 && i < 6) {
                if (tocheck[i].getAttribute("state") == tocheck[i+3].getAttribute("state")) { //check for two in a row (so first two columns)
                    if (tocheck[i-3].getAttribute("state") == null) {
                        canuse = "square_" + ((i*1)-2); // put the mark in the first row
                        if (!needtoblock) needtoblock = true;
                        if (tocheck[i].getAttribute("state") == comps_mark) break;
                    }
                }
            }
                
            // now find out if two on a diagonal
            if (i == 4) { //only checking if there's one in the middle, although there can be two on a diagonal either side of the middle, because i've made the computer go in the middle if its free, so this wont occur...
                if (tocheck[4].getAttribute("state") == tocheck[6].getAttribute("state")) {
                    if (tocheck[2].getAttribute("state") == null) {
                        canuse = "square_3"; // put the mark in top right square
                        if (!needtoblock) needtoblock = true;
                        if (tocheck[4].getAttribute("state") == comps_mark) break;
                    }
                }
                    
                if (tocheck[4].getAttribute("state") == tocheck[8].getAttribute("state")) {
                    if (tocheck[0].getAttribute("state") == null) {
                        canuse = "square_1"; // put the mark in top left square
                        if (!needtoblock) needtoblock = true;
                        if (tocheck[4].getAttribute("state") == comps_mark) break;
                    }
                }
                    
                if (tocheck[4].getAttribute("state") == tocheck[2].getAttribute("state")) {
                    if (tocheck[6].getAttribute("state") == null) {
                        canuse = "square_7"; // put the mark in bottom left square
                        if (!needtoblock) needtoblock = true;
                        if (tocheck[4].getAttribute("state") == comps_mark) break;
                    }
                }
                    
                if (tocheck[4].getAttribute("state") == tocheck[0].getAttribute("state")) {
                    if (tocheck[8].getAttribute("state") == null) {
                        canuse = "square_9"; // put the mark in top left square
                        if (!needtoblock) needtoblock = true;
                        if (tocheck[4].getAttribute("state") == comps_mark) break;
                    }
                }
            }
        }
    }
        
    if (!needtoblock) { //so there's no imminent lines to be made, so find the best place to put the computers mark - generally the corner where theres most free spaces
        for (var i=0; i < 9; i++) {
            //put one in the middle if its free
            if (tocheck[4].getAttribute("state") == null) {
                canuse = "square_5";
                break;
            } else {
                if (tocheck[i].getAttribute("state") == null) {
                    canuse = "square_" + ((i*1)+1);
                    break;
                }
            }
        }
    }

    if (canuse != null) {		
        //var comps_go = document.createTextNode(comps_mark);
        //document.getElementById(canuse).appendChild(comps_go);
        canuse = document.getElementById(canuse);
        canuse.setAttribute("state", comps_mark);
        canuse.style.backgroundImage = "url(ui/" + flavour + "/piece_" + comps_mark + "_drop_0.png)";
        setTimeout(function() {	
                    canuse.style.backgroundImage = "url(ui/" + flavour + "/piece_" + comps_mark + "_drop_1.png)";
                    setTimeout(function() {	
                            canuse.style.backgroundImage = "url(ui/" + flavour + "/piece_" + comps_mark + "_drop_2.png)";
                            setTimeout(function() {	
                                    canuse.style.backgroundImage = "url(ui/" + flavour + "/piece_" + comps_mark + "_normal.png)";
                                }, 70);
                        }, 50);
                    }, 30);
    }
}
    
function checkIfWon() { //seems a long way, i'll cut it down later
    var tocheck = document.getElementById("game_board").childNodes;
    var catsgame = true; //always assume its going to be a draw, and this only changes in the below
    
    for (var i=0; i < 9; i++) {
    //check for a line running horizontally
        if (tocheck[i].getAttribute("state") != null) {
            if (i == 0 || i == 3 || i == 6 ) {
                if (tocheck[i].getAttribute("state") == tocheck[i+1].getAttribute("state") && tocheck[i+1].getAttribute("state") == tocheck[i+2].getAttribute("state") ) {
                    finished = true;
                    catsgame = false;
                    gameWon(tocheck[i].getAttribute("state"));
                    break;
                } 
            }
        
        //check for a line running vertically
            if (i < 3) { //i.e. top row
                if (tocheck[i].getAttribute("state") == tocheck[i+3].getAttribute("state") && tocheck[i+3].getAttribute("state") == tocheck[i+6].getAttribute("state")) {
                    finished = true;
                    catsgame = false;
                    gameWon(tocheck[i].getAttribute("state"));
                    break;
                }
            }
        
        //check for the two diagonals
            if (i == 0) { //top left to bottom right diagonal
                if (tocheck[i].getAttribute("state") == tocheck[i+4].getAttribute("state") && tocheck[i+4].getAttribute("state") == tocheck[i+8].getAttribute("state")) {
                    finished = true;
                    catsgame = false;
                    gameWon(tocheck[i].getAttribute("state"));
                    break;
                }
            }
                
            if (i == 2) {
                if (tocheck[i].getAttribute("state") == tocheck[i+2].getAttribute("state") && tocheck[i+2].getAttribute("state") == tocheck[i+4].getAttribute("state")) {
                    finished = true;
                    catsgame = false;
                    gameWon(tocheck[i].getAttribute("state"));
                    break;
                }
            }
            
            if (i == 8 && catsgame) { //so done all the iterations and there's been nothing caught in the above and no free squares caught (catsgame = false below), then its a cats game, and alert it as such 
                finished = true;
                gameWon('cat');
            }
        } else {
            catsgame = false;
        }
    }
}
    
function gameWon(bywho) {
    var winner;
    switch (bywho) {
        case "cat":
            winner = "draw.png";
            break;
        case users_mark:
            winner = "winner.png";
            break;
        case comps_mark:
            winner = "loser.png";
            break;
    }
    
    setTimeout(function() { //looks better to have this wee delay in
                document.getElementById("end_game").style.background = "url(ui/panels/" + winner + ")";
                document.getElementById("end_game").style.display = "block";
            }, 300);
}
    
// create the game board - doing it this way instead of hard-coding the html cos i can't be arsed writing it all out, and it means less code

function create() {
    var top = 0;
    var left = 0;
    
    for (var i=1; i <= 9; i++) {
        var square = document.createElement("DIV");
        square.className = "square";
        
        square.style.top = top + "px";
        square.style.left = left + "px";
        
        square.id = "square_" + i;
        
        document.getElementById("game_board").appendChild(square);
        
        // check what i we're at so that the position of each square can be changed to fit
        
        left += 31;
        
        if (i%3 == 0) {
            left = 0;
            top += 31;
        }
    }
}
    
function replay() {
    finished = false;

    document.getElementById("end_game").style.display = "none";
    document.getElementById("game_board").innerHTML = "";
    
    create();
}
    
function toggleSettings() {
    var g = document.getElementById("game");
    var p = document.getElementById("prefs");
           
    if (g.style.display == "block") {
        g.style.display = "none";
        p.style.display = "block";
               
        document.getElementById("x_mark").src = "url(ui/" + flavour + "/piece_x_normal.png)";
        document.getElementById("o_mark").src = "url(ui/" + flavour + "/piece_o_normal.png)";
               
        document.getElementById("flip_button_1").removeEventListener("mousedown", function(e){e.target.src="ui/" + flavour + "/flipithoney_mousedown.png";}, false);
        document.getElementById("flip_button_1").removeEventListener("mouseup", function(e){e.target.src="ui/" + flavour + "/flipithoney_normal.png";}, false);
        document.getElementById("flip_button_2").addEventListener("mousedown", function(e){e.target.src="ui/" + flavour + "/flipithoney_mousedown.png";}, false);
        document.getElementById("flip_button_2").addEventListener("mouseup", function(e){e.target.src="ui/" + flavour + "/flipithoney_normal.png";}, false);
            
        if (window.widget) widget.prepareForTransition("ToBack");
        var u = document.getElementById(users_mark + "_mark");
        var c = document.getElementById(comps_mark + "_mark");
        var opac = 0.5;
        u.parentNode.style.opacity = 0.5; //className = "sel_nonfaded";
        c.parentNode.style.opacity = 1.0;
    } else {
        g.style.display = "block";
        p.style.display = "none";
               
        document.getElementById("flip_button_1").addEventListener("mousedown", function(e){e.target.src="ui/" + flavour + "/flipithoney_mousedown.png";}, false);
        document.getElementById("flip_button_1").addEventListener("mouseup", function(e){e.target.src="ui/" + flavour + "/flipithoney_normal.png";}, false);
        document.getElementById("flip_button_2").removeEventListener("mousedown", function(e){e.target.src="ui/" + flavour + "/flipithoney_mousedown.png";}, false);
        document.getElementById("flip_button_2").removeEventListener("mouseup", function(e){e.target.src="ui/" + flavour + "/flipithoney_normal.png";}, false);
                
        if (window.widget) widget.prepareForTransition("ToFront");
    }
    if (window.widget) setTimeout("widget.performTransition()", 0); //ahhh... now i get why it's in a timeout - it appears it doesn't update the content quick enough if it isn't :/
}
       
function selectFlavour(which) {
    if (which != flavour) {
        flavour = which;

        var flavs = document.getElementById("choosers").getElementsByTagName("IMG");
            
        for (var i=0; i < flavs.length; i++) {
            var sr = flavs[i].src.split("_");
            if (flavs[i].getAttribute("value") == which) {
                flavs[i].src = sr[0] + "_" + sr[1] + "_selected.png";
            } else {
                flavs[i].src = sr[0] + "_" + sr[1] + "_norm.png";
            }
        }
            
        fadeOut('prefs');
               
        var squares = document.getElementById("game_board").childNodes;
        //now, incase they are in the middle of a game when they change the color - go through and change the X and O's on the front...
        for (var i=0; i < squares.length; i++) {
            if (/_o_/.test(squares[i].style.backgroundImage)) {
                squares[i].style.backgroundImage = "url(ui/" + flavour + "/piece_o_normal.png)";
            }
            if (/_x_/.test(squares[i].style.backgroundImage)) {
                squares[i].style.backgroundImage = "url(ui/" + flavour + "/piece_x_normal.png)";
            }
        }
        if (window.widget) widget.setPreferenceForKey(flavour, "flavour");
    }
}
       
function fadeOut(what) {
    //i suppose the way i've done this is quite a nice example of scope... but that's about it, as it's a rather inelegent way of doing it :/
    var dif, opac;
    opac = 1.0;
    dif = 0.1;
    what = document.getElementById(what);
    var fader = setInterval(function() {
                            if (opac > 0.1) {
                                what.style.opacity = opac;
                                opac -= dif;
                            } else {
                                clearInterval(fader);
                                what.style.opacity = 0;
                                document.getElementById("flip_button_1").src="ui/" + flavour + "/flipithoney_normal.png";
                                document.getElementById("flip_button_2").src="ui/" + flavour + "/flipithoney_normal.png";
                                document.getElementById("game").style.background = "url(ui/" + flavour + "/background_front.png)";
                                document.getElementById("prefs").style.background = "url(ui/" + flavour + "/background_backside.png)";
                             
                                document.getElementById("x_mark").src = "url(ui/" + flavour + "/piece_x_normal.png)";
                                document.getElementById("o_mark").src = "url(ui/" + flavour + "/piece_o_normal.png)";

                                fadeIn(what);
                            }
                        }, 50);
}
    
function fadeIn(what) {
    var dif, opac;
    opac = 0.0;
    dif = 0.1;
      
    var fader = setInterval(function() {
                            if (opac <= 1) {
                                what.style.opacity = opac;
                                opac += dif;
                            } else {
                                clearInterval(fader);
                                document.getElementById("flavour").removeAttribute("disabled");
                            }
                        }, 50);
}

function init() {
    replay(); //rather than create() due to what appears to be a bug in mozilla
        
    document.getElementById("game").style.display = "block";
    document.getElementById("flip_button_1").src="ui/" + flavour + "/flipithoney_normal.png";
    document.getElementById("flip_button_2").src="ui/" + flavour + "/flipithoney_normal.png";

    document.getElementById("game_board").addEventListener("click", userClick, false);

    //uses the two buttons so the one on the back is incorporated in the fade effect...
    document.getElementById("flip_button_1").addEventListener("mousedown", function(e){e.target.src="ui/" + flavour + "/flipithoney_mousedown.png";}, false);
    document.getElementById("flip_button_1").addEventListener("mouseup", function(e){e.target.src="ui/" + flavour + "/flipithoney_normal.png";}, false);
       
    if (window.widget) {
        flavour = widget.preferenceForkey("flavour") || "blueberry";
        users_mark = widget.preferenceForkey("users_mark") || "x";
    }
    selectMark(users_mark);
}

window.onload = init;